

macroscript OMS_Billboard
	category:"OneManSoft"
	toolTip:"Billboard Generator"
-- copyright: Nir sullam http://www.orvatsel.com December 31st, 2009

(

	--==============================================================
--Read INI File and create presets list"  
presetsini = (getdir #maxRoot )+ "scripts\\startup\\billboard\\presets.ini"		
presetsFile = GetINISetting presetsini
presetsNumber = presetsFile.count
prestesList = #()
for j=1 to presetsNumber do prestesList[j]=GetINISetting presetsini ("preset"+ j as string) "name"
foldersList = #()
for j=1 to presetsNumber do foldersList[j]=GetINISetting presetsini ("preset"+ j as string) "folder"
filtersList = #()
for j=1 to presetsNumber do filtersList[j]=GetINISetting presetsini ("preset"+ j as string) "filter"
filtersmodeList = #()
for j=1 to presetsNumber do filtersmodeList[j]=GetINISetting presetsini ("preset"+ j as string) "filtermode"
replacestringList = #()
for j=1 to presetsNumber do replacestringList[j]=GetINISetting presetsini ("preset"+ j as string) "replace"	
formatlist = #()
for j=1 to presetsNumber do formatlist[j]=GetINISetting presetsini ("preset"+ j as string) "format"	
	--===============================================================

	

rollout billmats "Names" 
(
		
	
edittext meditname "Material Name: " pos:[15,10]  height:16 align:#center
edittext pname "Plane Name:      " pos:[15,35]  height:16 align:#center
)


rollout imgMaps "Image Maps"
(
global BG_maxver = maxVersion()
global presetsini 	
global fullpath
global currentformat	
global formatlist
global filteredimagelistnames	
global currentfolder
global currentfilter
global currentfiltermode 
global presetsFile
global replacestringList	
global currentrepalcestring	
global presetsNumber	
global folders = (getdir #maxRoot )+ "scripts\\startup\\billboard\\folders.ini"		
global prestesList
global foldersList	
global filtersList	
global filtersmodeList		
global presetindex
global inspt
global bmpval
global abmpval
global bmpname 
global meditSlotVal = 1
global dimfactor = 1
global meditisopen
global the_bmp
global diffuse_file
global templist	
global tmpname
global imagelist
global imagelistnames	
global bmpindex 
global diffuse_cnvs = bitmap 100 100 color:white
global alpha_file
global alpha_cnvs = bitmap 100 100 color:white
global lockmaps
global randfactor
global randmin
global randmax
global localhgt
global maxcount
global scatternumber
global CurrentBillBoard  
global  billboardgenDisplay1 = 0
global  billboardgenDisplay2 = 0
global sel_billboards
global flipbill
global billpivot
global rgb_outputval = 1.0
global hgtstr = ("Height (" + (units.SystemType as string) + ")")
global BillBoardFloater


group "Company Combination Presets:"
(

dropdownlist presets  items:prestesList   pos:[10,25]	width:200
button bbg_customize "C" width:15 pos:[210,25] 
	)

group "Color Correction Aids:"
(
button SBWG "Black Gray White" width:110 pos:[15,80] 
button SBWG2 "Gray Scale" width:80 pos:[130,80] 	
)

	
group "Custom Combination:"
(
button SBmp "Diffuse Bitmap" width:90 pos:[15,130] 
checkbutton btnlock images:#("lock.bmp", "lockmask.bmp", 1, 1, 1, 1, 1) pos:[105,130] 
button SABmp "Alpha Bitmap" width:90 pos:[125,130] 
)
bitmap diff_img width:100 height:100 pos:[10,170]
bitmap opac_img width:100 height:100 pos:[120,170]

 dropdownlist listimages  pos:[10,280]

spinner pwid  "Width:"  width:80 pos:[30,240] range:[0,6000,100] type:#float visible:false
spinner phgt "Height (system units): "   width:120  pos:[75,315] range:[0,6000,100] type:#float

checkbox flipme "Flip Horizontally " pos:[15,345] checked:false


checkbox enablerand "Random " pos:[15,370] checked:false
spinner rndoffset  "+/- (%):"  width:70 pos:[150, 370] range:[0.1,100,50] type:#float enabled:false
spinner outvalue  "Output Level:"  width:120 pos:[75, 390] range:[0.1,2,1] type:#float enabled:true



on imgMaps open do 
(phgt.text = hgtstr )

on bbg_customize pressed do 
(OMS_BillboardCFG())


on outvalue   changed RGBOUT do 

(

      rgb_outputval = RGBOUT   
)

--=============================================

on presets selected nameIndex do 
(
    currentfilter = filtersList[nameIndex]
	currentfolder = foldersList[nameIndex]
  	currentfiltermode = filtersmodeList[nameIndex]
  	currentrepalcestring = replacestringList[nameIndex]
	currentformat = formatlist[nameIndex]
	
	if currentfiltermode == "0" then
	(  btnlock.checked = true
	   SABmp.enabled = false 
	   opac_img.width = 0
	)  else
	(  btnlock.checked = false
	   SABmp.enabled = true 
	   opac_img.width = 100
	)	
	

imagelist = #()
imagelist = getFiles (currentfolder + "\\*." + currentformat)
currentfiltermode = filtersmodeList[nameIndex]

	
imagelistnames = #() 

 for j=1 to imagelist.count do imagelistnames[j]= getFilenameFile  imagelist[j]  
	 


 
filteredimagelistnames = #() 	 
 for j=1 to imagelist.count do 
	 ( if (matchpattern imagelistnames[j]  pattern:( "*" +  currentfilter))       != true  		 then 
		 append filteredimagelistnames ( getFilenameFile  imagelist[j] + getFilenameType imagelist[j] ) )

		 
		 
listimages.items = filteredimagelistnames 	-- populate the diplayed and filtered list of diffuse images 
	
	
)
--==============================================
-- Function of the Images Selection Dropdown list
on listimages selected nameIndex do 
(
    fullpath =  currentfolder + "\\" + filteredimagelistnames[nameIndex] 
	
	bmpval = openbitmap   fullpath 
		pwid.value = bmpval.width
		phgt.value = bmpval.height
		dimfactor = phgt.value / pwid.value
		bmpname = bmpval.filename
	
	        copy bmpval diffuse_cnvs
	    diff_img.bitmap = diffuse_cnvs
	    close bmpval

		if currentfiltermode == "1" then -- ADD Mode
	(		
		alphabase = fullpath
	
		alphaStringLength = alphabase.count
        alphaResultingName =   ( getFilenamePath alphabase + getFilenameFile  alphabase + currentfilter + getFilenameType alphabase ) 	 
        copy bmpval diffuse_cnvs
	    diff_img.bitmap = diffuse_cnvs
	    close bmpval
		abmpval =  openBitMap  alphaResultingName
        copy abmpval alpha_cnvs
        opac_img.bitmap = alpha_cnvs
        close abmpval
		)
	
	if currentfiltermode == "2" then -- REPALCE Mode
	(		
--		alphabase = bmpval.filename
		alphabase = fullpath
	    alphaStringLength = alphabase.count
        alphaResultingName = substituteString  alphabase currentrepalcestring currentfilter	 
				

		abmpval =  openBitMap  alphaResultingName
        copy abmpval alpha_cnvs
        opac_img.bitmap = alpha_cnvs
        close abmpval
		)
	    billmats.pname.text = "Billboard " + getfilenamefile  bmpval.filename
		billmats.meditname.text = billmats.pname.text

)
	
		
on flipme changed state do
(  if state == true
    then 
	(
	 flipbill = 1
		if $ != undefined and classof $ == omsbillboard then
   ( 
	   $.material.diffusemap.coords.U_Tiling = -1
	   	$.material.opacityMap.coords.U_Tiling = -1
   )
	   
	)
    else 
	(
		 flipbill = 0	
				if $ != undefined and classof $ == omsbillboard then
   ( 
	   $.material.diffusemap.coords.U_Tiling = 1
	   	$.material.opacityMap.coords.U_Tiling = 1
   )
	)
)

on enablerand changed state do
(  if state == true
    then 
	(
	rndoffset.enabled = true 

	)
    else 
	(
	rndoffset.enabled = false	
	)
)




on rndoffset changed randfactor do (
localhgt = imgMaps.phgt.value 
randmin = localhgt  - (localhgt  / 100 * randfactor)
randmax = localhgt  + (localhgt  / 100 * randfactor)
)


on btnlock changed state do
(  if state == true
    then 
	(
	lockmaps = 1
	SABmp.enabled = false 
	opac_img.width = 0
	)
    else 
	(
	lockmaps = 0
    SABmp.enabled = true
		opac_img.width = 100	
	)
)




on SABmp pressed do 
(
abmpval = selectBitMap caption:"Alpha Bitmap to Match:"  
	if abmpval == undefined then
    	 ( messagebox "You did not select an Alpha Map")
		 else
		 (
		  
copy abmpval alpha_cnvs
          opac_img.bitmap = alpha_cnvs
          close abmpval
		 )
	)


--=======================================================================================


	on SBWG pressed do 
(

tmpname = (getdir #maxRoot )+ "scripts\\startup\\billboard\\BlackWhiteGray.jpg"	
bmpval = openBitMap tmpname

 if bmpval == undefined then
     ( messagebox "File Not Fount !!!")
	 else (
	 	lockmaps = 1
    	SABmp.enabled = false 
	    opac_img.width = 0
		pwid.value = bmpval.width
		phgt.value = bmpval.height
		dimfactor = phgt.value / pwid.value
		bmpname = bmpval.filename
		billmats.pname.text = "Billboard " + getfilenamefile  bmpval.filename
		billmats.meditname.text = billmats.pname.text
  
		 BillBoardFloater.rollouts[7].cast_shadow.checked = false
	     BillBoardFloater.rollouts[7].rec_shadow.checked = false
		 BillBoardFloater.rollouts[7].reflec_visible.checked = false



copy bmpval diffuse_cnvs
	    diff_img.bitmap = diffuse_cnvs
	    close bmpval

	)
)

	on SBWG2 pressed do 
(

tmpname = (getdir #maxRoot )+ "scripts\\startup\\billboard\\bbggrayscale.jpg"	
bmpval = openBitMap tmpname

 if bmpval == undefined then
     ( messagebox "File Not Fount !!!")
	 else (
	 	lockmaps = 1
    	SABmp.enabled = false 
	    opac_img.width = 0
		pwid.value = bmpval.width
		phgt.value = bmpval.height
		dimfactor = phgt.value / pwid.value
		bmpname = bmpval.filename
		billmats.pname.text = "Billboard " + getfilenamefile  bmpval.filename
		billmats.meditname.text = billmats.pname.text
  
		 BillBoardFloater.rollouts[7].cast_shadow.checked = false
	     BillBoardFloater.rollouts[7].rec_shadow.checked = false
		 BillBoardFloater.rollouts[7].reflec_visible.checked = false



copy bmpval diffuse_cnvs
	    diff_img.bitmap = diffuse_cnvs
	    close bmpval

	)
)
	

on SBmp pressed do 
(
bmpval = selectBitMap caption:"Diffuse Bitmap to Match:"  

 if bmpval == undefined then
     ( messagebox "You did not select a Diffuse Map")
	 else (
		 
		pwid.value = bmpval.width
		phgt.value = bmpval.height
		dimfactor = phgt.value / pwid.value
		bmpname = bmpval.filename
		billmats.pname.text = "Billboard " + getfilenamefile  bmpval.filename
		billmats.meditname.text = billmats.pname.text
	    
copy bmpval diffuse_cnvs
	    diff_img.bitmap = diffuse_cnvs
	    close bmpval
	)
)




on pwid   changed newWid do 
(
a = newWid 

phgt.value = pwid.value * dimfactor


if $ != undefined and classof $ == omsbillboard then
   (
   oldpos = $.pos
   
$.delegate.length = phgt.value
   
$.delegate.width = pwid.value   
   $.pos = oldpos
   resetpivot $
   $.pivot.z = $.pos.z - 
phgt.value / 2
   $.pos = oldpos
   )


)





on phgt entered do 


(


if $ != undefined and classof $ == omsbillboard then
   ( phgt.value = $.delegate.length)

)



on phgt changed newHgt do 

(


if $ != undefined and classof $ == omsbillboard then
   (
   dimfactor =  $.delegate.length / $.delegate.width
   oldpos = $.pos
   phgt.value = newHgt 
   pwid.value = newHgt  / dimfactor
   
$.delegate.length = newHgt 
   
$.delegate.width = newHgt  / dimfactor 
   $.pos = oldpos
   resetpivot $
   $.pivot.z = $.pos.z - newHgt  / 2

   $.pos = oldpos   )
  else
  (
  phgt.value = newHgt 
  pwid.value = phgt.value / dimfactor
  )

)






)





rollout general "Collective Actions"
(

button selbills "Select All <" width:100 pos:[10,10] 
button delbills "Delete All <"  width:100 enabled:true pos:[10,35]
button rgbbills "RGB Output" width:100 pos:[10,60] 



	on  rgbbills pressed do

(  a = selection as array
            for o in a
                 where ((classof o) == omsbillboard) do
                  (o.material.diffusemap.output.RGB_Level = rgb_outputval)
	)
	

on  selbills pressed do

(
   sel_billboards = for a in objects where (classof a == omsbillboard) collect a
   select sel_billboards
	)






on  delbills pressed do

(
   sel_billboards = for a in objects where (classof a == omsbillboard) collect a
   delete sel_billboards
	)

)


rollout transforms "Transform"
(

button pickpos "Pick Point in Viewport <" width:150 pos:[10,10] 


button resetpos "Reset"  width:50 enabled:true pos:[170,10]


button pickmatch "From Object Pivot <" width:110 pos:[10,35] 
button pickcurr "Match Selected" width:100 pos:[130,35] 	
spinner nirX  "X:"
 range:[-1000000000,1000000000,0.0] pos:[15,65] width:55
spinner nirY  "Y:"
 range:[-1000000000,1000000000,0.0] pos:[90,65] width:55
spinner nirZ  "Z:" range:[-1000000000,1000000000,0.0] pos:[165,65] width:55

on  pickcurr pressed do
(
	if $ != undefined and classof $ == omsbillboard then
   (
    inspt = $
	billpivot = inspt.pivot
	nirX.value = billpivot.x	
    nirY.value = billpivot.y
    nirZ.value = billpivot.z
    nirposX = billpivot.x
    nirposY = billpivot.y
    nirposZ = billpivot.z
   )
	   )

on  pickmatch pressed do
(
    inspt = pickObject()
	billpivot = inspt.pivot
	nirX.value = billpivot.x	
    nirY.value = billpivot.y
    nirZ.value = billpivot.z
    nirposX = billpivot.x
    nirposY = billpivot.y
    nirposZ = billpivot.z
)





on  resetpos pressed do

(
    nirX.value = 0.0	
    nirY.value = 0.0
    nirZ.value = 0.0
    nirposX = 0.0
    nirposY = 0.0
    nirposZ = 0.0
	
	

	

if $ != undefined and classof $ == omsbillboard then
   (
   $.pos = [transforms.nirX.value,transforms.nirY.value,transforms.nirZ.value] 
   )

	)



on  pickpos pressed do

(
    inspt = pickPoint()
    nirX.value = inspt.x	
    nirY.value = inspt.y
    nirZ.value = inspt.z
    nirposX = inspt.x
    nirposY = inspt.y
    nirposZ = inspt.z
	
	

if $ != undefined and classof $ == omsbillboard then
   (
   $.pos = [transforms.nirX.value,transforms.nirY.value,transforms.nirZ.value] 
   )
	
)




on nirX   changed newX do (
if $ != undefined then
(
   $.pos = [transforms.nirX.value,transforms.nirY.value,transforms.nirZ.value]

)
)





on nirY   changed newY do (
if $ != undefined then
(
   $.pos = [transforms.nirX.value,transforms.nirY.value,transforms.nirZ.value]

)
)








on nirZ   changed newZ do (
if $ != undefined then
(
   $.pos = [transforms.nirX.value,transforms.nirY.value,transforms.nirZ.value]

)
)




)

rollout scatterthem "Scatter"
(


checkbox enableScatter "Enabled" pos:[15,10] checked:false

spinner dupes  "Duplicates:"
 range:[1,1000,0.0] pos:[140,10] width:85 type:#integer enabled:false
spinner scatX  "X:"
 range:[0,1000000000,500] pos:[15,40] width:65 enabled:false
spinner scatY  "Y:"
 range:[0,1000000000,500] pos:[90,40] width:65 enabled:false

on enableScatter changed state do
(  if state == false
    then 
	(
	dupes.enabled = false 
    scatX.enabled = false 
    scatY.enabled = false 

	)
    else 
	(
	dupes.enabled = true	
	scatX.enabled = true	
	scatY.enabled = true	
	)
)


)

rollout params "Parameters"
(
checkbox cast_shadow "Cast Shadows" checked:true pos:[10,10]
checkbox rec_shadow "Recieve Shadows" checked:true pos:[10,35]
checkbox cam_visible "Visible to camera" checked:true pos:[10,60]
checkbox reflec_visible "Visible in reflections" checked:true pos:[10,85]
checkbox seethru "See-Through" checked:false pos:[10,110]



on cast_shadow changed castState do


(


if $ != undefined and classof $ == omsbillboard then
   (
 $.castShadows = castState 
   )
)



on rec_shadow changed recState do


(


if $ != undefined and classof $ == omsbillboard then
   (
$.receiveshadows = recState 
   )
)





on cam_visible changed visState do


(


if $ != undefined and classof $ == omsbillboard then
   (
$.primaryVisibility = visState 
   )
)





on reflec_visible changed refState do


(


if $ != undefined and classof $ == omsbillboard then
   (
$.secondaryVisibility = refState 
   )
)





on seethru  changed xrayState do


(


if $ != undefined and classof $ == omsbillboard then
   (
$.xray = xrayState 
   )
)


)



rollout orientit "Connections"
(
button orient "Orient billboard to selected camera" width:180 pos:[15,10] enabled:false
button orientall "Orient All  to Selected camera" width:180 pos:[15,35] enabled:true
listbox camlist "" items:(for o in cameras where (classof o != Targetobject  ) collect o.name) height:6 pos:[15,60]
 button delorientall "Delete Orientation of all" width:220 pos:[15,160] enabled:true
	-- button camrefresh "Refresh Cameras List" width:120 pos:[15,145]

on  camrefresh pressed do
(
templist = (for o in cameras where (classof o != Targetobject  ) collect o.name)

camlist.items = templist 

	)


on  orientall pressed do
(
	
 sel_billboards = for a in objects where (classof a == omsbillboard) collect a

for a in 	sel_billboards do
(
b = addconstraint a  "rotation" orientation_constraint false
 b.appendtarget $ 100
	
)

	)	
	
on  delorientall pressed do
(
	
 sel_billboards = for a in objects where (classof a == omsbillboard) collect a

for a in 	sel_billboards do
(
a.rotation.controller.deleteTarget 1
	
)

	)	
	


on  orient pressed do
(
tempOBJ = addconstraint CurrentBillBoard  "rotation" orientation_constraint false
tempOBJ.appendtarget $ 50
 select CurrentBillBoard
	)


on camlist selected nameIndex do 
(
select (getNodeByName camlist.items[nameIndex])
currentCam = (getNodeByName camlist.items[nameIndex])

if  
CurrentBillBoard != undefined then
(
 orient.enabled = true

)




 
)

)

rollout aboutbillboard "About"
(
label developer "Copyright \xa9 2006-2010 Nir Sullam"

button Weblink "Billboard Website" width:120 align:#center 

	On Weblink pressed do
		(
		assetBrowser.open()
		assetBrowser.gotoURL "http://www.orvatsel.com/max"
		)

)


rollout displays "Display"
(


checkbox displaylabels "Show labels" pos:[15,10] checked:false




checkbox displaymarkers "Show markers" pos:[15,30] checked:false
button hidebill "Hide Billboards" width:100 pos:[15,50] 
button unhidebill "Unhide Billboards" width:100 pos:[130,50] 


	On unhidebill pressed do
		(
		
a = objects as array
            for o in a
                 where ((classof o) == omsbillboard) do
                  (unhide o)
			
		)



	On hidebill pressed do
		(
		
a = objects as array
            for o in a
                 where ((classof o) == omsbillboard) do
                  (hide o)
		

		)

on displaylabels changed state do
(  if state == false
    then 
	(
      billboardgenDisplay1 = 0 

	)
    else 
	(
      billboardgenDisplay1 = 1
	)
)

on displaymarkers changed state do
(  if state == false
    then 
	(
      billboardgenDisplay2 = 0 

	)
    else 
	(
     billboardgenDisplay2 = 1
	)
)
)





rollout finals "Generate"
(
button ApplyMe "Generate !" width:90 pos:[65,10]  
checkbox enablevrml "Attach a VRML Billboard Helper" pos:[15,40] checked:false



on ApplyMe pressed do 

(

 if bmpval == undefined then
     ( messagebox "A Diffuse Map must be selected")
	 else if abmpval == undefined and lockmaps == 0 then
     ( messagebox "An Alpha Map must be selected")
	 else 
	 (


if 
scatterthem.
dupes.enabled == true then
   maxcount = scatterthem.dupes.value else
   maxcount = 1




for i = 1 to maxcount do
(

omsbillboard length:1 width:1 pos:[transforms.nirX.value,transforms.nirY.value,transforms.nirZ.value] isSelected:on lengthsegs:1 widthsegs:1

CurrentBillBoard = $
rotate $ (angleaxis 90 [1,0,0])
randfactor = imgMaps.rndoffset.value  

localhgt = imgMaps.phgt.value 





if randmin == undefined then
   randmin = imgMaps.phgt.value - (imgMaps.phgt.value  / 100 * randfactor) 



if randmax == undefined then
   randmax = imgMaps.phgt.value + (imgMaps.phgt.value  / 100 * randfactor) 


if imgMaps.enablerand.checked == true then
   $.delegate.length= random randmin randmax
  else
   $.delegate.length= imgMaps.phgt.value 



$.delegate.width= $.delegate.length / dimfactor
$.delegate.lengthsegs = 1

$.delegate.widthsegs = 1

-- If version i 8 or higher - disallow the use of real world dimensions on the generated script
if ( BG_maxver[1]  > 8000 ) then
   $.delegate.realWorldMapSize = false



if billmats.pname.text == "" then
   billmats.pname.text = "Billboard UNNAMED"
   
$.name = billmats.pname.text



if 
scatterthem.
dupes.enabled == true then
   move $ [ (random 0 scatterthem.scatX.value)  ,  (random 0 scatterthem.scatY.value)  ,  $.delegate.length/2 ]  else
   move $ [0,0,$.delegate.length/2]



$.pivot = [transforms.nirX.value,transforms.nirY.value,transforms.nirZ.value]

$.material = standard diffusemap:(Bitmaptexture()) 
$.material.diffusemap.bitmap = bmpval
$.material.diffusemap.coords.blur = 0.01
---------------------------------
tmp = $.material.diffusemap
tmp.output.RGB_Level = rgb_outputval


if flipbill  == 1 then
($.material.diffusemap.coords.U_Tiling = 1)
else 
(
$.material.diffusemap.coords.U_Tiling = -1)

$.material.opacityMap = Bitmaptexture()
if lockmaps == 1 then
  (
  $.material.opacityMap.bitmap = bmpval
  $.material.opacityMap.monooutput = 1  
  $.material.opacityMap.rgboutput = 1   
     
$.material.opacityMap.coords.blur = 0.01
	

if flipbill  == 1 then
	($.material.opacityMap.coords.U_Tiling = 1)
	else 
	(
$.material.opacityMap.coords.U_Tiling = -1)

  )
  else

  ($.material.opacityMap.bitmap = abmpval
   
$.material.opacityMap.coords.blur = 0.01
	

if flipbill  == 1 then
	($.material.opacityMap.coords.U_Tiling = 1)
	else 
	(
$.material.opacityMap.coords.U_Tiling = -1)
)



if params.reflec_visible.state == on then
  $.secondaryVisibility = on
  else
    $.secondaryVisibility = off

if params.cam_visible.state == on then
  $.primaryVisibility = on
  else
    $.primaryVisibility = off
if params.cast_shadow.state == on then
  $.castShadows = on
  else
    $.castShadows = off



if params.rec_shadow.state == on then
  $.receiveshadows = on
  else
    $.receiveshadows = off



if params.seethru.state == on then
  $.xray = on
  else
    $.xray = off
$.material.twoSided = on
$.material.glossiness = 0
$.material.specularLevel = 0

--$.material.name =  billmats.meditname.text

billmats.meditname.text = $.material.name =  $.name

showTextureMap $.material on



if finals.enablevrml.state == on then
(
billparent = $
billchild = billboard()
billchild.name = "VRML " + billchild.name
max link
billparent.parent = billchild
)


)
)

		 BillBoardFloater.rollouts[7].cast_shadow.checked = true
	     BillBoardFloater.rollouts[7].rec_shadow.checked = true
		 BillBoardFloater.rollouts[7].reflec_visible.checked = true

) -- end Applyme button

)

-- ===============================================================================================



if BillBoardFloater  != undefined do
				(
				closerolloutfloater BillBoardFloater 
				)

BillBoardFloater = newRolloutFloater "Billboard Generator 3.0 BETA 006" 250 800
addRollout imgMaps BillBoardFloater 
addRollout finals BillBoardFloater 

addRollout Transforms BillBoardFloater 
addRollout orientit BillBoardFloater
addRollout billmats BillBoardFloater  rolledUp:on
addRollout scatterthem BillBoardFloater rolledUp:on
addRollout params BillBoardFloater rolledUp:on
addRollout general BillBoardFloater rolledUp:on

addRollout displays BillBoardFloater rolledUp:on
addRollout aboutbillboard BillBoardFloater rolledUp:on
	

	---------------------------------------------------------------------------
	( unregisterRedrawViewsCallback BillboardcamRefresh
		fn BillboardcamRefresh =
(
	--   if cameras.count >= 0 then 
	templist = (for o in cameras where (classof o != Targetobject  ) collect o.name)
     BillBoardFloater.rollouts[4].camlist.items = templist 
)
   registerRedrawViewsCallback BillboardcamRefresh
)
---------------------------------------------------------------------------


-- BillBoardFloater
cui.RegisterDialogBar BillBoardFloater minsize: [200,200] maxsize: [-1,-1] style:#(#cui_dock_vert, #cui_floatable, #cui_handles)

)


--=========================================================================


--macroscript OMS_BillboardCFG
--category:"OneManSoft"
--	toolTip:"Billboard Generator Configurator"
-- copyright: Nir sullam http://www.orvatsel.com December 14th, 2009

fn OMS_BillboardCFG =

(
global 	BBConfigOMS
try(destroydialog BBConfigOMS)catch()	

global presetsini = (getdir #maxRoot )+ "scripts\\startup\\billboard\\presets.ini"		
global presetsFile = GetINISetting presetsini
global presetnumberInt = presetsFile.count + 1
	
	rollout BBConfigOMS "Billboard Configurator 1.02 Alpha"

(
global replace_string	
global output_1	
global output_2
global output_3
global output_4
global output_5
global output_6
global output_7	
global presetnumberInt	
global filtermodestring 
global filter_string 
global replace_string 	
global presetsini
global presetsFile
global presetnumberInt
 

	

group "Preset:"	
	(
spinner presetnum "Preset Number:" fieldWidth:50 pos:[10,25] range:[1,500,presetnumberInt]  labelOnTop:false type:#integer 
edittext preset_name "Preset Name:  " fieldWidth:180 pos:[10,50] labelOnTop:false	
	)
	group "Naming Conventions Modes:"
(
radiobuttons filter_type labels:#("Diffuse File Only (files such as TIFF TGA) ", "Base Name + string (such as Tree1 and Tree1-A)", "Base name is modified (Tree1-A and Tree1-C)") columns:1 pos:[10,105]  default:2
)
group "Files:"
(
button SelDiff "Select Diffuse File" width:140 pos:[10,180] enabled:true 
edittext diff_txt "Diffuse File Name:" fieldWidth:180 pos:[10,210] labelOnTop:false
button SelAlpha "Select Matching Alpha File" width:140 pos:[10,240] enabled:true 
edittext alpha_txt "Alpha File Name:  " fieldWidth:180 pos:[10,270] labelOnTop:false
	
	)


button makefilter "Evaluate Filter String" width:140 pos:[10,300] enabled:true 
edittext filter_txt      "Filter String:    " fieldWidth:150 pos:[10,330] labelOnTop:false
edittext folder_txt    "Folder:            " fieldWidth:150 pos:[10,360] labelOnTop:false		
edittext replace_txt  "Replace String: " fieldWidth:150 pos:[10,390] labelOnTop:false		
edittext format_txt   "File Format:     "  fieldWidth:150 pos:[10,420] labelOnTop:false		

group "Final Output text (Copy and Paste to INI File):"
(	
edittext output_txt "" fieldWidth:255 height: 100 pos:[10,470] labelOnTop:false		
button gen_list "Create INI Settings List" width:120 pos:[10,580] enabled:true 	
button copy_list "Copy List to Clipboard" width:120 pos:[140,580] enabled:true 	
	)

	
		on copy_list pressed do 
	(
	 setclipboardtext output_txt.text
		)	

	on gen_list pressed do 
	(
	
 if preset_name.text == "" then
     ( messagebox "A Name Must be assigned for current preset!")
	 else 
	 (
		

	
		if filtermodestring == undefined do filtermodestring = "1"
		if replace_string == undefined do filtermodestring = ""			
		
	output_1 = "[Preset" + presetnumberInt as string  + "]"
    output_2 = " name = " + preset_name.text 
    output_3 = " folder = " + folder_txt.text 		
    output_4 = " filter = " + filter_txt.text 	
    output_5 = " filtermode = " + filtermodestring 
    output_6 = " replace =  " + replace_txt.text  
    output_7 = " format =  " + format_txt.text  		
	cliptext = 	output_txt.text = output_1  + "\r\n" + output_2 + "\r\n" + output_3 + "\r\n" + output_4 + "\r\n" + output_5 + "\r\n" + output_6 + "\r\n" + output_7
 
		)	)


on presetnum changed val do 
(presetnumberInt =  val 
	print presetnumberInt
)

on filter_type changed state  do 
(
	case filter_type.state of (
	1: (
		
		filtermodestring =  "0"
		filter_string = "nofilter"
		replace_string = " "
		makefilter.enabled = false
		filter_txt.enabled = true
		filter_txt.text = filter_string
		replace_txt.enabled = false
		SelAlpha.enabled = false
		alpha_txt.enabled = false
	)
	2: (
		
		filtermodestring =  "1"
		filter_string = "nofilter"
		replace_string = " "	
				makefilter.enabled = true
		filter_txt.enabled = true
				filter_txt.text = ""		
		replace_txt.enabled = true
		SelAlpha.enabled = true
		alpha_txt.enabled = true		
	)
	3: (
		
		filtermodestring =  "2"
		filter_string = "nofilter"
		replace_string = ""	
		makefilter.enabled = true	
		filter_txt.enabled = true
				filter_txt.text = ""
		replace_txt.enabled = true
		SelAlpha.enabled = true
		alpha_txt.enabled = true			
	)	
		
	)
	
)
	
	
	
	on makefilter pressed do 
(
	
a = alpha_txt.text
b = diff_txt.text
c = ""
	
if a != "" and b != "" do
(	
for j=1 to a.count do  (if b[j] != a[j] then c=c + a[j])
filter_txt.text = c	
)
	
	)	

	
	
	on seldiff pressed do 
(
bmpval = selectBitMap caption:"Select A Diffuse Map File: "  
	if bmpval == undefined then
    	 ( messagebox "You did not select a Diffuse Map File")
		 else
		 (
		  
	diff_txt.text = getFilenameFile bmpval.filename
	folder_txt.text = getFilenamePath bmpval.filename			 
	format_txt.text = substring  (getFilenameType  bmpval.filename)		2 -1
			 close bmpval
		 )
	)
	
		on SelAlpha pressed do 
(
abmpval = selectBitMap caption:"Select a Matching Alpha Map File: "  
	if abmpval == undefined then
    	 ( messagebox "You did not select a Matching Alpha File")
		 else
		 (
		  
	alpha_txt.text = getFilenameFile abmpval.filename

			 close bmpval
		 )
	)


	
	

)
createdialog BBConfigOMS width:290 height:630


)
