

macroscript OMS_Billboard
	category:"OneManSoft"
	toolTip:"Billboard Generator"
-- copyright: Nir sullam http://www.orvatsel.com Feb. 13, 2009

(


	

rollout billmats "Names" 
(
		
	
edittext meditname "Material Name: " pos:[15,10]  height:16 align:#center
edittext pname "Plane Name:      " pos:[15,35]  height:16 align:#center
)


rollout imgMaps "Image Maps"
(
global BG_maxver = maxVersion()
global inspt
global bmpval
global abmpval
global bmpname 
global meditSlotVal = 1
global dimfactor = 1
global meditisopen
global the_bmp
global diffuse_file
global templist	
 
global diffuse_cnvs = bitmap 100 100 color:white
global alpha_file
global alpha_cnvs = bitmap 100 100 color:white
global lockmaps
global randfactor
global randmin
global randmax
global localhgt
global maxcount
global scatternumber
global CurrentBillBoard  
global  billboardgenDisplay1 = 0
global  billboardgenDisplay2 = 0
global sel_billboards
global flipbill
global billpivot
global rgb_outputval = 1.0
global hgtstr = ("Height (" + (units.SystemType as string) + ")")



group "Company Combination Presets:"
(
button SBmp1 "Got 3D" width:90 pos:[15,25] 
button SBmp2 "Cad Plants" width:90 pos:[115,25] 
button SBmp3 "Imagecels" width:90 pos:[15,50] 
button SBmp4 "Ambient Light" width:90 pos:[115,50] 
button SBmp5 "Dosch Design" width:90 pos:[15,75] 
button SBmp6 "Marlin Studios" width:90 pos:[115,75] 	
	)
group "Custom Combination:"
(
button SBmp "Diffuse Bitmap" width:90 pos:[15,125] 
checkbutton btnlock images:#("lock.bmp", "lockmask.bmp", 1, 1, 1, 1, 1) pos:[105,125] 
button SABmp "Alpha Bitmap" width:90 pos:[125,125] 
)
bitmap diff_img width:100 height:100 pos:[10,165]
bitmap opac_img width:100 height:100 pos:[120,165]
spinner pwid  "Width:"  width:80 pos:[30,175] range:[0,6000,100] type:#float visible:false
spinner phgt "Height (system units): "   width:120  pos:[75,285] range:[0,6000,100] type:#float

checkbox flipme "Flip Horizontally " pos:[15,315] checked:false


checkbox enablerand "Random " pos:[15,340] checked:false
spinner rndoffset  "+/- (%):"  width:70 pos:[150, 340] range:[0.1,100,50] type:#float enabled:false
spinner outvalue  "Output Level:"  width:120 pos:[75, 360] range:[0.1,2,1] type:#float enabled:true



on imgMaps open do 
(phgt.text = hgtstr )




on outvalue   changed RGBOUT do 

(

      rgb_outputval = RGBOUT   
)





on flipme changed state do
(  if state == true
    then 
	(
	 flipbill = 1
		if $ != undefined and classof $ == omsbillboard then
   ( 
	   $.material.diffusemap.coords.U_Tiling = -1
	   	$.material.opacityMap.coords.U_Tiling = -1
   )
	   
	)
    else 
	(
		 flipbill = 0	
				if $ != undefined and classof $ == omsbillboard then
   ( 
	   $.material.diffusemap.coords.U_Tiling = 1
	   	$.material.opacityMap.coords.U_Tiling = 1
   )
	)
)

on enablerand changed state do
(  if state == true
    then 
	(
	rndoffset.enabled = true 

	)
    else 
	(
	rndoffset.enabled = false	
	)
)









on rndoffset changed randfactor do (
localhgt = imgMaps.phgt.value 
randmin = localhgt  - (localhgt  / 100 * randfactor)
randmax = localhgt  + (localhgt  / 100 * randfactor)
)


on btnlock changed state do
(  if state == true
    then 
	(
	lockmaps = 1
	SABmp.enabled = false 
	opac_img.width = 0
	)
    else 
	(
	lockmaps = 0
    SABmp.enabled = true
		opac_img.width = 100	
	)
)




on SABmp pressed do 
(
abmpval = selectBitMap caption:"Alpha Bitmap to Match:"  
	if abmpval == undefined then
    	 ( messagebox "You did not select an Alpha Map")
		 else
		 (
		  
copy abmpval alpha_cnvs
          opac_img.bitmap = alpha_cnvs
          close abmpval
		 )
	)



	on SBmp1 pressed do 
(
bmpval = selectBitMap caption:"Got 3D Diffuse Bitmap:"  

 if bmpval == undefined then
     ( messagebox "You did not select a Diffuse Map")
	 	else (
		lockmaps = 0
        SABmp.enabled = true
		opac_img.width = 100	
		pwid.value = bmpval.width
		phgt.value = bmpval.height
		dimfactor = phgt.value / pwid.value
		bmpname = bmpval.filename
		alphabase = bmpval.filename
        alphaStringLength = alphabase.count
        alphaResultingName = substring alphabase 1 (alphaStringLength - 4) + "_Alpha.jpg"
		
		 
		billmats.pname.text = "Billboard " + getfilenamefile  bmpval.filename
		billmats.meditname.text = billmats.pname.text
	    
copy bmpval diffuse_cnvs
	    diff_img.bitmap = diffuse_cnvs
	    close bmpval
	 abmpval =  openBitMap  alphaResultingName
copy abmpval alpha_cnvs
        opac_img.bitmap = alpha_cnvs
          close abmpval
	)
)



	on SBmp2 pressed do 
(
bmpval = selectBitMap caption:"CAD Plants Diffuse Bitmap:"  
rgb_outputval = 0.8
outvalue.value = rgb_outputval
 if bmpval == undefined then
     ( messagebox "You did not select a Diffuse Map")
	 else (
		lockmaps = 0
        SABmp.enabled = true
		opac_img.width = 100	
		pwid.value = bmpval.width
		phgt.value = bmpval.height
		dimfactor = phgt.value / pwid.value
		bmpname = bmpval.filename
		alphabase = bmpval.filename
        alphaStringLength = alphabase.count
        alphaResultingName = substring alphabase 1 (alphaStringLength - 4) + "a.jpg"
		
		 
		billmats.pname.text = "Billboard " + getfilenamefile  bmpval.filename
		billmats.meditname.text = billmats.pname.text
	    
copy bmpval diffuse_cnvs
	    diff_img.bitmap = diffuse_cnvs
	    close bmpval
	 abmpval =  openBitMap  alphaResultingName
copy abmpval alpha_cnvs
        opac_img.bitmap = alpha_cnvs
          close abmpval
	)
)
	

	on SBmp3 pressed do 
(
bmpval = selectBitMap caption:"Imagecels Diffuse Bitmap:"  
print bmpval
 if bmpval == undefined then
     ( messagebox "You did not select a Diffuse Map")
	 else (
	 	lockmaps = 1
    	SABmp.enabled = false 
	    opac_img.width = 0
		pwid.value = bmpval.width
		phgt.value = bmpval.height
		dimfactor = phgt.value / pwid.value
		bmpname = bmpval.filename
		billmats.pname.text = "Billboard " + getfilenamefile  bmpval.filename
		billmats.meditname.text = billmats.pname.text
	    
copy bmpval diffuse_cnvs
	    diff_img.bitmap = diffuse_cnvs
	    close bmpval

	)
)
	


	on SBmp4 pressed do 
(
bmpval = selectBitMap caption:"Ambient Light Diffuse Bitmap:"  

 if bmpval == undefined then
     ( messagebox "You did not select a Diffuse Map")
	 else (
		lockmaps = 0
        SABmp.enabled = true
		opac_img.width = 100	
		pwid.value = bmpval.width
		phgt.value = bmpval.height
		dimfactor = phgt.value / pwid.value
		bmpname = bmpval.filename
		alphabase = bmpval.filename
        alphaStringLength = alphabase.count
        alphaResultingName = substring alphabase 1 (alphaStringLength - 5) + "A.jpg"
		
		 
		billmats.pname.text = "Billboard " + getfilenamefile  bmpval.filename
		billmats.meditname.text = billmats.pname.text
	    
copy bmpval diffuse_cnvs
	    diff_img.bitmap = diffuse_cnvs
	    close bmpval
	 abmpval =  openBitMap  alphaResultingName
copy abmpval alpha_cnvs
        opac_img.bitmap = alpha_cnvs
          close abmpval
	)
)



on SBmp5 pressed do 
(
bmpval = selectBitMap caption:"Dosch Design Diffuse Bitmap:"  

 if bmpval == undefined then
     ( messagebox "You did not select a Diffuse Map")
	 	else (
		lockmaps = 0
        SABmp.enabled = true
		opac_img.width = 100	
		pwid.value = bmpval.width
		phgt.value = bmpval.height
		dimfactor = phgt.value / pwid.value
		bmpname = bmpval.filename
		alphabase = bmpval.filename
        alphaStringLength = alphabase.count
        alphaResultingName = substring alphabase 1 (alphaStringLength - 4) + "_A.tga"
		
		 
		billmats.pname.text = "Billboard " + getfilenamefile  bmpval.filename
		billmats.meditname.text = billmats.pname.text
	    
copy bmpval diffuse_cnvs
	    diff_img.bitmap = diffuse_cnvs
	    close bmpval
	 abmpval =  openBitMap  alphaResultingName
copy abmpval alpha_cnvs
        opac_img.bitmap = alpha_cnvs
          close abmpval
	)
)


	on SBmp6 pressed do 
(
bmpval = selectBitMap caption:"Marlin Studios Diffuse Bitmap:"  
print bmpval
 if bmpval == undefined then
     ( messagebox "You did not select a Diffuse Map")
	 else (
	 	lockmaps = 1
    	SABmp.enabled = false 
	    opac_img.width = 0
		pwid.value = bmpval.width
		phgt.value = bmpval.height
		dimfactor = phgt.value / pwid.value
		bmpname = bmpval.filename
		billmats.pname.text = "Billboard " + getfilenamefile  bmpval.filename
		billmats.meditname.text = billmats.pname.text
	    
copy bmpval diffuse_cnvs
	    diff_img.bitmap = diffuse_cnvs
	    close bmpval

	)
)
	

on SBmp pressed do 
(
bmpval = selectBitMap caption:"Diffuse Bitmap to Match:"  

 if bmpval == undefined then
     ( messagebox "You did not select a Diffuse Map")
	 else (
		 print bmpval
		pwid.value = bmpval.width
		phgt.value = bmpval.height
		dimfactor = phgt.value / pwid.value
		bmpname = bmpval.filename
		billmats.pname.text = "Billboard " + getfilenamefile  bmpval.filename
		billmats.meditname.text = billmats.pname.text
	    
copy bmpval diffuse_cnvs
	    diff_img.bitmap = diffuse_cnvs
	    close bmpval
	)
)




on pwid   changed newWid do 
(
a = newWid 

phgt.value = pwid.value * dimfactor


if $ != undefined and classof $ == omsbillboard then
   (
   oldpos = $.pos
   
$.delegate.length = phgt.value
   
$.delegate.width = pwid.value   
   $.pos = oldpos
   resetpivot $
   $.pivot.z = $.pos.z - 
phgt.value / 2
   $.pos = oldpos
   )


)





on phgt entered do 


(


if $ != undefined and classof $ == omsbillboard then
   ( phgt.value = $.delegate.length)

)



on phgt changed newHgt do 

(


if $ != undefined and classof $ == omsbillboard then
   (
   dimfactor =  $.delegate.length / $.delegate.width
   oldpos = $.pos
   phgt.value = newHgt 
   pwid.value = newHgt  / dimfactor
   
$.delegate.length = newHgt 
   
$.delegate.width = newHgt  / dimfactor 
   $.pos = oldpos
   resetpivot $
   $.pivot.z = $.pos.z - newHgt  / 2

   $.pos = oldpos   )
  else
  (
  phgt.value = newHgt 
  pwid.value = phgt.value / dimfactor
  )

)






)





rollout general "Collective Actions"
(

button selbills "Select All <" width:100 pos:[10,10] 
button delbills "Delete All <"  width:100 enabled:true pos:[10,35]
button rgbbills "RGB Output" width:100 pos:[10,60] 



	on  rgbbills pressed do

(  a = selection as array
            for o in a
                 where ((classof o) == omsbillboard) do
                  (o.material.diffusemap.output.RGB_Level = rgb_outputval)
	)
	

on  selbills pressed do

(
   sel_billboards = for a in objects where (classof a == omsbillboard) collect a
   select sel_billboards
	)






on  delbills pressed do

(
   sel_billboards = for a in objects where (classof a == omsbillboard) collect a
   delete sel_billboards
	)

)


rollout transforms "Transform"
(

button pickpos "Pick Point in Viewport <" width:150 pos:[10,10] 


button resetpos "Reset"  width:50 enabled:true pos:[170,10]


button pickmatch "From Object Pivot <" width:110 pos:[10,35] 
button pickcurr "Match Selected" width:100 pos:[130,35] 	
spinner nirX  "X:"
 range:[-1000000000,1000000000,0.0] pos:[15,65] width:55
spinner nirY  "Y:"
 range:[-1000000000,1000000000,0.0] pos:[90,65] width:55
spinner nirZ  "Z:" range:[-1000000000,1000000000,0.0] pos:[165,65] width:55

on  pickcurr pressed do
(
	if $ != undefined and classof $ == omsbillboard then
   (
    inspt = $
	billpivot = inspt.pivot
	nirX.value = billpivot.x	
    nirY.value = billpivot.y
    nirZ.value = billpivot.z
    nirposX = billpivot.x
    nirposY = billpivot.y
    nirposZ = billpivot.z
   )
	   )

on  pickmatch pressed do
(
    inspt = pickObject()
	billpivot = inspt.pivot
	nirX.value = billpivot.x	
    nirY.value = billpivot.y
    nirZ.value = billpivot.z
    nirposX = billpivot.x
    nirposY = billpivot.y
    nirposZ = billpivot.z
)





on  resetpos pressed do

(
    nirX.value = 0.0	
    nirY.value = 0.0
    nirZ.value = 0.0
    nirposX = 0.0
    nirposY = 0.0
    nirposZ = 0.0
	
	

	

if $ != undefined and classof $ == omsbillboard then
   (
   $.pos = [transforms.nirX.value,transforms.nirY.value,transforms.nirZ.value] 
   )

	)



on  pickpos pressed do

(
    inspt = pickPoint()
    nirX.value = inspt.x	
    nirY.value = inspt.y
    nirZ.value = inspt.z
    nirposX = inspt.x
    nirposY = inspt.y
    nirposZ = inspt.z
	print inspt
	

if $ != undefined and classof $ == omsbillboard then
   (
   $.pos = [transforms.nirX.value,transforms.nirY.value,transforms.nirZ.value] 
   )
	
)




on nirX   changed newX do (
if $ != undefined then
(
   $.pos = [transforms.nirX.value,transforms.nirY.value,transforms.nirZ.value]

)
)





on nirY   changed newY do (
if $ != undefined then
(
   $.pos = [transforms.nirX.value,transforms.nirY.value,transforms.nirZ.value]

)
)








on nirZ   changed newZ do (
if $ != undefined then
(
   $.pos = [transforms.nirX.value,transforms.nirY.value,transforms.nirZ.value]

)
)




)

rollout scatterthem "Scatter"
(


checkbox enableScatter "Enabled" pos:[15,10] checked:false

spinner dupes  "Duplicates:"
 range:[1,1000,0.0] pos:[140,10] width:85 type:#integer enabled:false
spinner scatX  "X:"
 range:[0,1000000000,500] pos:[15,40] width:65 enabled:false
spinner scatY  "Y:"
 range:[0,1000000000,500] pos:[90,40] width:65 enabled:false

on enableScatter changed state do
(  if state == false
    then 
	(
	dupes.enabled = false 
    scatX.enabled = false 
    scatY.enabled = false 

	)
    else 
	(
	dupes.enabled = true	
	scatX.enabled = true	
	scatY.enabled = true	
	)
)


)

rollout params "Parameters"
(
checkbox cast_shadow "Cast Shadows" checked:true pos:[10,10]
checkbox rec_shadow "Recieve Shadows" checked:true pos:[10,35]
checkbox cam_visible "Visible to camera" checked:true pos:[10,60]
checkbox reflec_visible "Visible in reflections" checked:true pos:[10,85]
checkbox seethru "See-Through" checked:false pos:[10,110]



on cast_shadow changed castState do


(


if $ != undefined and classof $ == omsbillboard then
   (
 $.castShadows = castState 
   )
)



on rec_shadow changed recState do


(


if $ != undefined and classof $ == omsbillboard then
   (
$.receiveshadows = recState 
   )
)





on cam_visible changed visState do


(


if $ != undefined and classof $ == omsbillboard then
   (
$.primaryVisibility = visState 
   )
)





on reflec_visible changed refState do


(


if $ != undefined and classof $ == omsbillboard then
   (
$.secondaryVisibility = refState 
   )
)





on seethru  changed xrayState do


(


if $ != undefined and classof $ == omsbillboard then
   (
$.xray = xrayState 
   )
)


)



rollout orientit "Connections"
(
listbox camlist "" items:(for o in cameras where (classof o != Targetobject  ) collect o.name) height:6 pos:[15,40]
button orient "Orient billboard to selected camera" width:180 pos:[15,10] enabled:false
button orientall "Orient All  to Selected camera" width:180 pos:[15,135] enabled:true
	-- button camrefresh "Refresh Cameras List" width:120 pos:[15,145]

on  camrefresh pressed do
(
templist = (for o in cameras where (classof o != Targetobject  ) collect o.name)

camlist.items = templist 

	)


on  orientall pressed do
(
	
 sel_billboards = for a in objects where (classof a == omsbillboard) collect a

for a in 	sel_billboards do
(
b = addconstraint a  "rotation" orientation_constraint false
 b.appendtarget $ 100
)

	)	
	



on  orient pressed do
(
tempOBJ = addconstraint CurrentBillBoard  "rotation" orientation_constraint false
tempOBJ.appendtarget $ 50
 select CurrentBillBoard
	)


on camlist selected nameIndex do 
(
select (getNodeByName camlist.items[nameIndex])
currentCam = (getNodeByName camlist.items[nameIndex])

if  
CurrentBillBoard != undefined then
(
 orient.enabled = true

)




 
)

)

rollout aboutbillboard "About"
(
label developer "Copyright \xa9 2006-2007 Nir Sullam"

button Weblink "Billboard Website" width:120 align:#center 

	On Weblink pressed do
		(
		assetBrowser.open()
		assetBrowser.gotoURL "http://www.orvatsel.com/max"
		)

)


rollout displays "Display"
(


checkbox displaylabels "Show labels" pos:[15,10] checked:false




checkbox displaymarkers "Show markers" pos:[15,30] checked:false
button hidebill "Hide Billboards" width:100 pos:[15,50] 
button unhidebill "Unhide Billboards" width:100 pos:[130,50] 


	On unhidebill pressed do
		(
		
a = objects as array
            for o in a
                 where ((classof o) == omsbillboard) do
                  (unhide o)
			
		)



	On hidebill pressed do
		(
		
a = objects as array
            for o in a
                 where ((classof o) == omsbillboard) do
                  (hide o)
		

		)

on displaylabels changed state do
(  if state == false
    then 
	(
      billboardgenDisplay1 = 0 

	)
    else 
	(
      billboardgenDisplay1 = 1
	)
)

on displaymarkers changed state do
(  if state == false
    then 
	(
      billboardgenDisplay2 = 0 

	)
    else 
	(
     billboardgenDisplay2 = 1
	)
)
)





rollout finals "Generate"
(
button ApplyMe "Generate !" width:90 pos:[65,10]  
checkbox enablevrml "Attach a VRML Billboard Helper" pos:[15,40] checked:false



on ApplyMe pressed do 

(

 if bmpval == undefined then
     ( messagebox "A Diffuse Map must be selected")
	 else if abmpval == undefined and lockmaps == 0 then
     ( messagebox "An Alpha Map must be selected")
	 else 
	 (


if 
scatterthem.
dupes.enabled == true then
   maxcount = scatterthem.dupes.value else
   maxcount = 1




for i = 1 to maxcount do
(

omsbillboard length:1 width:1 pos:[transforms.nirX.value,transforms.nirY.value,transforms.nirZ.value] isSelected:on lengthsegs:1 widthsegs:1

CurrentBillBoard = $
rotate $ (angleaxis 90 [1,0,0])
randfactor = imgMaps.rndoffset.value  

localhgt = imgMaps.phgt.value 





if randmin == undefined then
   randmin = imgMaps.phgt.value - (imgMaps.phgt.value  / 100 * randfactor) 



if randmax == undefined then
   randmax = imgMaps.phgt.value + (imgMaps.phgt.value  / 100 * randfactor) 


if imgMaps.enablerand.checked == true then
   $.delegate.length= random randmin randmax
  else
   $.delegate.length= imgMaps.phgt.value 



$.delegate.width= $.delegate.length / dimfactor
$.delegate.lengthsegs = 1

$.delegate.widthsegs = 1

-- If version i 8 or higher - disallow the use of real world dimensions on the generated script
if ( BG_maxver[1]  > 8000 ) then
   $.delegate.realWorldMapSize = false



if billmats.pname.text == "" then
   billmats.pname.text = "Billboard UNNAMED"
   
$.name = billmats.pname.text



if 
scatterthem.
dupes.enabled == true then
   move $ [ (random 0 scatterthem.scatX.value)  ,  (random 0 scatterthem.scatY.value)  ,  $.delegate.length/2 ]  else
   move $ [0,0,$.delegate.length/2]



$.pivot = [transforms.nirX.value,transforms.nirY.value,transforms.nirZ.value]

$.material = standard diffusemap:(Bitmaptexture()) 
$.material.diffusemap.bitmap = bmpval
$.material.diffusemap.coords.blur = 0.01
---------------------------------
tmp = $.material.diffusemap
tmp.output.RGB_Level = rgb_outputval


if flipbill  == 1 then
($.material.diffusemap.coords.U_Tiling = 1)
else 
(
$.material.diffusemap.coords.U_Tiling = -1)

$.material.opacityMap = Bitmaptexture()
if lockmaps == 1 then
  (
  $.material.opacityMap.bitmap = bmpval
  $.material.opacityMap.monooutput = 1  
  $.material.opacityMap.rgboutput = 1   
     
$.material.opacityMap.coords.blur = 0.01
	

if flipbill  == 1 then
	($.material.opacityMap.coords.U_Tiling = 1)
	else 
	(
$.material.opacityMap.coords.U_Tiling = -1)

  )
  else

  ($.material.opacityMap.bitmap = abmpval
   
$.material.opacityMap.coords.blur = 0.01
	

if flipbill  == 1 then
	($.material.opacityMap.coords.U_Tiling = 1)
	else 
	(
$.material.opacityMap.coords.U_Tiling = -1)
)



if params.reflec_visible.state == on then
  $.secondaryVisibility = on
  else
    $.secondaryVisibility = off

if params.cam_visible.state == on then
  $.primaryVisibility = on
  else
    $.primaryVisibility = off
if params.cast_shadow.state == on then
  $.castShadows = on
  else
    $.castShadows = off



if params.rec_shadow.state == on then
  $.receiveshadows = on
  else
    $.receiveshadows = off



if params.seethru.state == on then
  $.xray = on
  else
    $.xray = off
$.material.twoSided = on
$.material.glossiness = 0
$.material.specularLevel = 0

--$.material.name =  billmats.meditname.text

billmats.meditname.text = $.material.name =  $.name

showTextureMap $.material on



if finals.enablevrml.state == on then
(
billparent = $
billchild = billboard()
billchild.name = "VRML " + billchild.name
max link
billparent.parent = billchild
)


)
)
)

)

-- ===============================================================================================



if BillBoardFloater  != undefined do
				(
				closerolloutfloater BillBoardFloater 
				)

BillBoardFloater = newRolloutFloater "Billboard Generator 2.7a" 250 800
addRollout imgMaps BillBoardFloater 
addRollout finals BillBoardFloater 

addRollout Transforms BillBoardFloater 
addRollout orientit BillBoardFloater
addRollout billmats BillBoardFloater  rolledUp:on
addRollout scatterthem BillBoardFloater rolledUp:on
addRollout params BillBoardFloater rolledUp:on
addRollout general BillBoardFloater rolledUp:on

addRollout displays BillBoardFloater rolledUp:on
addRollout aboutbillboard BillBoardFloater rolledUp:on
	

	---------------------------------------------------------------------------
	( unregisterRedrawViewsCallback BillboardcamRefresh
		fn BillboardcamRefresh =
(
     templist = (for o in cameras where (classof o != Targetobject  ) collect o.name)
     BillBoardFloater.rollouts[4].camlist.items = templist 
)
   registerRedrawViewsCallback BillboardcamRefresh
)
---------------------------------------------------------------------------


-- BillBoardFloater
cui.RegisterDialogBar BillBoardFloater minsize: [200,200] maxsize: [-1,-1] style:#(#cui_dock_vert, #cui_floatable, #cui_handles)

)